function [data] = syn_collate_sub()
%This function works on an output data directory structure and generates a
%simplified experiment directory structure (collated_data), which is then
%used by join_verts and maybe join_sum.  For the expected structure of the
%input directory structure look at the syn_collate-directory.dia.
%Synatax:   [data] = syn_collate_sub();
%Input:     you will be prompted to point to the root of the directory
%               structure.
%Output:    data = dataset of filenames and directory names

data = [];      %initialize.
%localization for macs
if ispc
    slash = '\';        %Windows directory marker
else
    slash = '/';        %Mac directory marker
end

dir_root = uigetdir2('','Directory where the files are located');    %get the directory

dir_lv1 = dir(dir_root);    %get the file structure of the root dir.
out_root = [dir_root,slash,'collated',slash];   %make the output directory structure root
mkdir(out_root);         %create the output root.

%now lets crank through the directories
for i = 3:size(dir_lv1,1)   %level 1: always start on 3 as 1 and 2 are . and .. (Dir: 20110308...etc.)
    if dir_lv1(i).isdir     %if this is a directory continue; else case...who cares
        dir_lv2 = dir([dir_root,slash,dir_lv1(i).name]);  %now get the directory structure of the next level
        dir_tmp = [dir_root,slash,dir_lv1(i).name,slash]; %the current level 2 directory 
        if dir_end(dir_lv2)     %Test if this is the end level
            %Get here later
            error('There is a strict directory structure, and this is not it.');    %did not mean to use a strict directory structure
            %But storing an x possible drill down directory structure in a
            %n possible cell array, turns out to be too unwieldy.  Look at
            %the stored ver0.2 if you want to resurrect this, but for now
            %we are deadlocking this.  Check dir_struct.dia for the proper
            %directory structure.
        else    %not the end yet(expected)
            for j = 3:size(dir_lv2,1)   %level 2: Care about the name of this level (Dir: WT, KO, etc.)
                if dir_lv2(j).isdir     %if is a directory continue; else case not important.
                    dir_lv3 = dir([dir_tmp,dir_lv2(j).name]);   %get the third level
                    dir_tmp2 = [dir_tmp,dir_lv2(j).name,slash];  %the current level3 directory
                    if dir_end(dir_lv3)
                        %Come back for this later
                        error('There is a strict directory structure, and this is not it.');
                    else    %no the end yet(expected)
                        for k = 3:size(dir_lv3,1)   %level 3: The care about level (Dir: Layer23, Layer4, etc.)
                            if dir_lv3(k).isdir     %go forth; we don't care about files
                                dir_lv4 = dir([dir_tmp2,dir_lv3(k).name]);   %get the fourth level
                                dir_tmp3 = [dir_tmp2,dir_lv3(k).name,slash];  %the current level 4 directory
                                if dir_end(dir_lv4)
                                    error(['There is a strict directory structure, and this is not it.',dir_tmp3]);
                                else
                                    for l = 3:size(dir_lv4,1)   %level4: Men's Wear (Dir: R1, R2, etc.)
                                        if dir_lv4(l).isdir
                                            dir_lv5 = dir([dir_tmp3,dir_lv4(l).name]);  %get the fifth level
                                            dir_tmp4 = [dir_tmp3,dir_lv4(l).name,slash]; %The current level 5 directory
                                            if dir_end(dir_lv5) 
                                                error('There is a strict directory structure, and this is not it.');
                                            else
                                                for m = 3:size(dir_lv5,1)   %level5: One more to go (Dir: VGluT1, VGluT2, etc.)
                                                    if dir_lv5(m).isdir
                                                        dir_lv6 = dir([dir_tmp4,dir_lv5(m).name]);   %The end level
                                                        dir_tmp5 = [dir_tmp4,dir_lv5(m).name,slash];
                                                        %we only care about the files now.
                                                        if size(dir_lv6,1)==0
                                                            keyboard
                                                        end
                                                        [aprop,acount,aucount] = process_files(dir_lv6);     %get the files we want to move
                                                        %now setup the out put directory structure
                                                        warning 'off'   %set it off so no annoying chirps for creating a directory
                                                        mkdir(out_root,dir_lv5(m).name);    %create the root folder for this syn class
                                                        mkdir([out_root,dir_lv5(m).name,slash],dir_lv2(j).name);    %KO 
                                                        mkdir([out_root,dir_lv5(m).name,slash,dir_lv2(j).name,slash],dir_lv3(k).name);  %layer4
%                                                         out_flat = [out_root,dir_lv5(m).name,slash,dir_lv2(j).name,slash,dir_lv3(k).name,slash,'flat',slash];
%                                                         mkdir(out_flat);
%                                                         out_prop = [out_root,dir_lv5(m).name,slash,dir_lv2(j).name,slash,dir_lv3(k).name,slash,'prop',slash];
%                                                         mkdir(out_prop);
%                                                         out_aflat = [out_root,dir_lv5(m).name,slash,dir_lv2(j).name,slash,dir_lv3(k).name,slash,'aflat',slash];
%                                                         mkdir(out_aflat);
                                                        out_aprop = [out_root,dir_lv5(m).name,slash,dir_lv2(j).name,slash,dir_lv3(k).name,slash,'aprop',slash];
                                                        mkdir(out_aprop);
%                                                         out_count = [out_root,dir_lv5(m).name,slash,dir_lv2(j).name,slash,dir_lv3(k).name,slash,'count',slash];
%                                                         mkdir(out_count);
                                                        out_acount = [out_root,dir_lv5(m).name,slash,dir_lv2(j).name,slash,dir_lv3(k).name,slash,'allcount',slash];
                                                        mkdir(out_acount);
                                                        out_aucount = [out_root,dir_lv5(m).name,slash,dir_lv2(j).name,slash,dir_lv3(k).name,slash,'alluniquecount',slash];
                                                        mkdir(out_aucount);
%                                                         out_rotated = [out_root,dir_lv5(m).name,slash,dir_lv2(j).name,slash,dir_lv3(k).name,slash,'rotated',slash];
%                                                         mkdir(out_rotated);
                                                        warning 'on'    %back on
                                                        %create out dir tmp
%                                                         for n = 1:size(flat,2) %go through files and copy them to new destinations
%                                                             copyfile([dir_tmp5,flat{n}],[out_flat,num2str(i-2),num2str(l-2),'_',flat{n}]);
%                                                         end
%                                                         for o = 1:size(prop,2) %no copy over the properties files
%                                                             copyfile([dir_tmp5,prop{o}],[out_prop,num2str(i-2),num2str(l-2),'_',prop{o}]);
%                                                         end
%                                                         for n = 1:size(aflat,2) %go through files and copy them to new destinations
%                                                             copyfile([dir_tmp5,aflat{n}],[out_aflat,num2str(i-2),num2str(l-2),'_',aflat{n}]);
%                                                         end
                                                        for o = 1:size(aprop,2) %no copy over the properties files
                                                            copyfile([dir_tmp5,aprop{o}],[out_aprop,num2str(i-2),num2str(l-2),'_',aprop{o}]);
                                                        end
%                                                         for n = 1:size(count,2) %go through files and copy them to new destinations
%                                                             copyfile([dir_tmp5,count{n}],[out_count,num2str(i-2),num2str(l-2),'_',count{n}]);
%                                                         end
                                                        for o = 1:size(acount,2) %no copy over the properties files
                                                            copyfile([dir_tmp5,acount{o}],[out_acount,num2str(i-2),num2str(l-2),'_',acount{o}]);
                                                        end
                                                        for n = 1:size(aucount,2) %go through files and copy them to new destinations
                                                            copyfile([dir_tmp5,aucount{n}],[out_aucount,num2str(i-2),num2str(l-2),'_',aucount{n}]);
                                                        end
%                                                         for o = 1:size(rotated,2) %no copy over the properties files
%                                                             copyfile([dir_tmp5,rotated{o}],[out_rotated,num2str(i-2),num2str(l-2),'_',rotated{o}]);
%                                                         end
                                                    end
                                                end
                                            end
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
    end
end
                   
        
        
%--------------------------------------------------------------------------
%sub function to figure out if this level is only files, meaning this is
%the end dir.
function [is_end] = dir_end(dir_struct)

is_end = 0;  %initiate

for i = 3:size(dir_struct,1)    %go through the 
    is_end(i-2)=dir_struct(i).isdir;     %pull the isdir info
end

is_end = logical(1-max(is_end));       %readout of whether this directory has only files.

%--------------------------------------------------------------------------
%subfunction to seperate files from directories
function [aprop,acount,aucount] = process_files(dir_struct)

for i = 3:size(dir_struct,1)    %go through the 
    idx(i-2) = dir_struct(i).isdir;     %pull the isdir info
    names{i-2} = dir_struct(i).name;     %pull the file and dir names
end

%get the files
try
list = names(~idx);
catch
    keyboard
end
%filter for only the files we want
% flat_idx = ones(size(list));   %create an index for selecting the flat files
% prop_idx = ones(size(list));   %same for prop
% aflat_idx = ones(size(list));   %create an index for selecting the flat files
aprop_idx = ones(size(list));   %same for prop
% count_idx = ones(size(list));   %create an index for selecting the flat files
acount_idx = ones(size(list));   %same for prop
aucount_idx = ones(size(list));   %same for prop
% rotated_idx = ones(size(list));   %same for prop
for j = 1:size(list,2);
    %the only files we care about are the flat rotated vertices and the properties for now
%     if ~strcmp('flat',list{j}(1:4))
%         flat_idx(j) = 0;    %set this for removal
%     end
%     if ~strcmp('prop',list{j}(1:4))
%         prop_idx(j) = 0;    %set this for removal
%     end
%     if ~strcmp('aflat',list{j}(1:5))
%         aflat_idx(j) = 0;    %set this for removal
%     end
    if ~strcmp('aprop',list{j}(1:5))
        aprop_idx(j) = 0;    %set this for removal
    end
%     if ~strcmp('count',list{j}(1:5))
%         count_idx(j) = 0;    %set this for removal
%     end
    if ~strcmp('allco',list{j}(1:5)) %allcount
        acount_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('allun',list{j}(1:5))  %alluniquecount
        aucount_idx(j) = 0;    %set this for removal
    end
%     if ~strcmp('rotat',list{j}(1:5))  %rotated
%         rotated_idx(j) = 0;    %set this for removal
%     end
end
%create the desired lists of file names.
% flat = list(logical(flat_idx));    %list for flat vertices files
% prop = list(logical(prop_idx));    %list for prop files
% aflat = list(logical(aflat_idx));    %list for flat vertices files
aprop = list(logical(aprop_idx));    %list for prop filesflat = list(logical(flat_idx));    %list for flat vertices files
% count = list(logical(count_idx));    %list for flat vertices files
acount = list(logical(acount_idx));    %list for prop filesflat = list(logical(flat_idx));    %list for flat vertices files
aucount = list(logical(aucount_idx));    %list for flat vertices files
% rotated = list(logical(rotated_idx));    %list for prop filesflat = list(logical(flat_idx));    %list for flat vertices files

% flat(logical(flat_idx)) = [];   %remove
% prop(logical(prop_idx)) = [];   %gone